import React from "react";
import { startCase } from "lodash-es";

interface Props {
  register: any;
  fieldName: string;
  fieldLabel?: string;
  required?: boolean;
  isValidated?: boolean;
  validateFn?: () => void;
  handleKeyDown?: () => void;
  defaultValue?: string;
  placeholder?: string | boolean;
  isDisabled?: boolean;
}

const TextArea: React.FC<Props> = ({
  register,
  fieldName,
  fieldLabel,
  required,
  isValidated,
  validateFn,
  handleKeyDown,
  defaultValue,
  placeholder = true,
  isDisabled,
}) => {
  return (
    <textarea
      id={fieldName}
      rows={4}
      defaultValue={defaultValue}
      className="w-full rounded border-2 bg-transparent py-2.5 px-3 text-black outline-none transition focus:border-primary active:border-primary disabled:cursor-default disabled:bg-whiter dark:border-form-strokedark dark:bg-form-input dark:text-white dark:focus:border-primary"
      placeholder={
        placeholder
          ? typeof placeholder === "string"
            ? placeholder
            : `Enter ${
                fieldLabel?.toLowerCase() || startCase(fieldName).toLowerCase()
              }...`
          : ""
      }
      {...register(fieldName, {
        required: required ? "This field is required." : false,
        validate: isValidated ? validateFn : undefined,
      })}
      onKeyDown={handleKeyDown}
      autoComplete="on"
      disabled={isDisabled}
    />
  );
};

export default TextArea;
