import React from 'react';

interface CustomCheckboxProps {
    checked?: boolean;
    onToggle?: (checked: boolean) => void;
    label?: string;
}

const CustomCheckbox: React.FC<CustomCheckboxProps> = ({ checked = false, onToggle, label }) => {
    const handleChange = () => {
        onToggle && onToggle(!checked);
    };

    return (
        <div className="">
            <div
                className={` ${checked ? "styles.active" : ''}`}
                onClick={handleChange}
            />
            {label && <span className="">{label}</span>}
        </div>
    );
};

export default CustomCheckbox;